% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setFOR_parameters}
\alias{seasonder_setFOR_parameters}
\title{Set First Order Region (FOR) Parameters for a SeaSondeRCS Object}
\usage{
seasonder_setFOR_parameters(seasonder_cs_object, FOR_parameters)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing FOR-related metadata.}

\item{FOR_parameters}{A named list of parameters for first-order region detection.}
}
\value{
The updated SeaSondeRCS object with the new FOR parameters.
}
\description{
This function validates and sets the FOR parameters in the SeaSondeRCS object.
It updates the "FOR_data" attribute with validated parameters and, if the noise factor
has changed, recomputes the noise level for all three antennas.
}
\details{
The provided parameters are validated using \code{seasonder_validateFOR_parameters()},
and then stored in the object's "FOR_data" attribute under \code{FOR_parameters}.
If the \code{noisefact} parameter changes, the noise level is recomputed for antennas 1, 2, and 3.
}
\examples{
# Set sample file paths
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
new_params <- list(nsm = 3, noisefact = 4, fdown = 12, flim = 80, currmax = 2.5)
cs_obj <- seasonder_setFOR_parameters(cs_obj, new_params)
}
