% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setFOR_noisefact}
\alias{seasonder_setFOR_noisefact}
\title{Set FOR Noise Factor (noisefact)}
\usage{
seasonder_setFOR_noisefact(seasonder_cs_object, noisefact)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object with FOR parameters.}

\item{noisefact}{A numeric value that specifies the noise factor.}
}
\value{
The updated SeaSondeRCS object with the new \code{noisefact} value.
}
\description{
This function sets the noise factor (\code{noisefact}) used in FOR processing
for the given SeaSondeRCS object.
}
\examples{
# Set sample file paths
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
cs_obj <- seasonder_setFOR_noisefact(cs_obj, 4)
}
