% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_rerun_qc_with_fun}
\alias{seasonder_rerun_qc_with_fun}
\title{Structured Restart for Quality Control}
\usage{
seasonder_rerun_qc_with_fun(cond, qc_fun)
}
\arguments{
\item{cond}{The condition object captured during the execution of the
\code{read_and_qc_field} function.}

\item{qc_fun}{An alternate quality control function to apply. This function should accept
the value from the field as its sole argument and return a QC-applied value.}
}
\value{
The value returned by the alternate quality control function.
}
\description{
Provides a structured restart mechanism to rerun the quality control (QC) function
with an alternative function during the execution of \code{read_and_qc_field}.
This allows for a flexible error recovery strategy when the initial QC function fails
or is deemed inadequate.
}
\details{
This function is meant to be used within custom condition handlers for the
\code{read_and_qc_field} function.
}
\examples{
# Example (expected to error due to missing restart):
val <- try(
  seasonder_rerun_qc_with_fun(
    list(seasonder_value = 42),
    function(x) x * 2
  ),
  silent = TRUE
)
print(val)
}
