% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_readSeaSondeCSFileBlock}
\alias{seasonder_readSeaSondeCSFileBlock}
\title{Read and Apply Quality Control to a Block of Fields}
\usage{
seasonder_readSeaSondeCSFileBlock(spec, connection, endian = "big")
}
\arguments{
\item{spec}{A named list of specifications for fields to read. Each specification should be in
the form:
list(type = "data_type", qc_fun = "qc_function_name", qc_params = list(param1 = value1, ...))
Where:
\itemize{
\item \code{type}: is the data type to read, which will be passed to \code{seasonder_readCSField}.
\item \code{qc_fun}: is the name of a quality control function. This function should be present in the
shared environment \code{seasonder_the} and must accept \code{field_value} as its first argument,
followed by any other arguments specified in \code{qc_params}.
\item \code{qc_params}: is a list of additional parameters to pass to the quality control function.
}}

\item{connection}{A connection to the binary file.}

\item{endian}{A character string indicating the byte order. Options are "big" and "little" (default is "big").}
}
\value{
A named list where each entry corresponds to a field that has been read. Each key is
the field name, and its associated value is the data for that field after quality control.
}
\description{
Reads a block of fields from a binary file based on provided specifications. Each field is read
and then processed with a specified quality control function.
}
\details{
The quality control (QC) functions (\code{qc_fun}) specified within \code{spec} play a pivotal role in ensuring the
reliability of the data that's read. Here's the expected behavior of these QC functions:
\itemize{
\item \strong{Input}:
\itemize{
\item \code{field_value}: Value of the field that has been read from the binary file using the \code{seasonder_readCSField} function.
\item \code{...}: Additional parameters specified in \code{qc_params} that are passed to \code{qc_fun} for quality control.
}
\item \strong{Functioning}:
The QC function receives a read value and performs checks or transformations based on defined rules or parameters.
\itemize{
\item \strong{On QC failure}:
\itemize{
\item The QC function itself is responsible for determining the action to take. It can log an error, return a default
value, impute the value, and more.
\item For critical errors, the QC function could halt the execution. However, note that logging is managed by the QC
function and won't necessarily halt execution in every case.
}
\item \strong{On success}:
The QC function will return the value (either unchanged or transformed).
}
\item \strong{Output}:
Value that has been validated or transformed based on quality control rules.
\item \strong{Additional Notes}:
\itemize{
\item The action on QC failure is directly implemented within the QC function.
\item Reading errors are managed by the \code{seasonder_readCSField} function, which returns NULL in the case of an error. It
is up to the QC function to decide what to do if it receives a NULL.
}
}
}
\examples{
spec <- list(field1 = list(type = "UInt8", qc_fun = "qc_check_unsigned", qc_params = list()))
con <- rawConnection(as.raw(c(0x01)))
block <- seasonder_readSeaSondeCSFileBlock(spec, con, endian = "big")
print(block)
close(con)
}
\seealso{
\code{\link{read_and_qc_field}}
}
