% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getSeaSondeRCS_ProcessingSteps}
\alias{seasonder_getSeaSondeRCS_ProcessingSteps}
\title{Getter for ProcessingSteps}
\usage{
seasonder_getSeaSondeRCS_ProcessingSteps(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{SeaSonderCS object}
}
\value{
A list containing the processing steps of the SeaSondeRCS object.
}
\description{
Getter for ProcessingSteps
}
\examples{
# Create a SeaSondeRCS object for examples
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
# Retrieve processing steps
processing_steps <- seasonder_getSeaSondeRCS_ProcessingSteps(cs_obj)
print(processing_steps)
}
