% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_getFOR_fdown}
\alias{seasonder_getFOR_fdown}
\title{Retrieve FOR Power Dropoff Threshold (fdown)}
\usage{
seasonder_getFOR_fdown(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing FOR parameters.}
}
\value{
The value of the 'fdown' parameter.
}
\description{
This function retrieves the power dropoff threshold ('fdown') for First Order Region detection
from a SeaSondeRCS object.
}
\examples{
# Minimal example for seasonder_getFOR_fdown
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
fdown_value <- seasonder_getFOR_fdown(cs_obj)
print(fdown_value)
}
