% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_computeNoiseLevel}
\alias{seasonder_computeNoiseLevel}
\title{Compute Noise Level for First Order Region (FOR) Processing}
\usage{
seasonder_computeNoiseLevel(seasonder_cs_object, antenna = 3, smoothed = FALSE)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing spectral data and FOR parameters.}

\item{antenna}{A numeric value specifying the antenna from which to extract self-spectra (default is 3).}

\item{smoothed}{Logical; if \code{TRUE}, the function uses a smoothed version of the self-spectra.}
}
\value{
The updated \code{SeaSondeRCS} object with the computed noise level stored in its attributes.
}
\description{
This function estimates the noise level in the self-spectra of a SeaSondeR cross‐spectral object.
The noise level is determined by averaging the spectral power over a predefined frequency range
where no first-order Bragg signal is expected. This value is later used in setting signal-to-noise
thresholds for FOR detection.
}
\details{
The noise level is computed via the following steps:
\enumerate{
\item \strong{Determine Noise Reference Limits:}
\itemize{
\item Retrieves the normalized Doppler frequency limits for noise reference from the FOR parameters
(using \code{seasonder_getFOR_parameters}).
\item Converts these normalized limits into Doppler bin indices using \code{seasonder_SwapDopplerUnits}.
\item If any of the resulting bin indices are missing, they are replaced with appropriate default boundaries
(i.e., upper limit set to the total number of Doppler cells and lower limit set to 1).
}
\item \strong{Extract Spectral Data for Noise Estimation:}
\itemize{
\item The function extracts the self-spectra from the specified antenna (using \code{seasonder_getSeaSondeRCS_SelfSpectra}),
limiting the extraction to the Doppler bins within the computed noise reference range (both negative and positive regions).
}
\item \strong{Compute the Average Noise Level:}
\itemize{
\item The spectral data from both the negative and positive Doppler regions are concatenated, and
the row-wise mean is calculated to estimate the average noise level.
}
\item \strong{Store the Noise Level:}
\itemize{
\item The computed average noise level is stored in the object's \code{NoiseLevel} attribute by calling
\code{seasonder_setSeaSondeRCS_NoiseLevel}.
\item A processing step message is logged using \code{SeaSondeRCS_computeNoiseLevel_step_text}.
}
}

The resulting noise level is essential for setting accurate thresholds during FOR detection.
}
\seealso{
\itemize{
\item \code{\link{seasonder_getFOR_parameters}} for retrieving noise reference limits.
\item \code{\link{seasonder_SwapDopplerUnits}} for converting normalized Doppler frequencies into bin indices.
\item \code{\link{seasonder_getSeaSondeRCS_SelfSpectra}} for extracting self-spectra.
\item \code{\link{seasonder_setSeaSondeRCS_NoiseLevel}} for storing the computed noise level.
}
}
