% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_SeaSondeRCSMUSICInterpolateDoppler}
\alias{seasonder_SeaSondeRCSMUSICInterpolateDoppler}
\title{Perform Doppler Interpolation for SeaSonde Cross-Spectra Data}
\usage{
seasonder_SeaSondeRCSMUSICInterpolateDoppler(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing cross-spectra data and metadata for processing.}
}
\value{
A \code{SeaSondeRCS} object with updated interpolated cross-spectra data and metadata.
}
\description{
This function performs Doppler interpolation on the cross-spectra data of a SeaSondeRCS object, preparing the data for MUSIC processing.
Interpolation is achieved by inserting additional Doppler bins using linear interpolation, potentially increasing the number of detected vectors while possibly smoothing the radials. The function tries to mimic CODAR's AnalyzeSpectra tool interpolation, including the addition of a wraparound Doppler cell before interpolation.
}
\details{
Doppler interpolation increases the number of Doppler bins by a factor of 2, 3, or 4 before radial processing.
This is accomplished by linearly interpolating between existing bins, increasing the number of radial vectors by approximately 15\% for a 2x interpolation, and yielding smoother radials. The interpolation factor is configurable via the SeaSondeRCS object's \code{doppler_interpolation} attribute and it's setter \code{seasonder_setSeaSondeRCS_MUSIC_doppler_interpolation}. The number of Doppler bins after interpolation should not exceed 2048; exceeding this limit will result in an error.

The interpolation process is as follows:
\enumerate{
\item A wraparound Doppler cell is added to the right of the data.
\item For non-quality-control (QC) matrices, linear interpolation is applied to fill in the newly added Doppler bins.
\item QC matrices are updated with a default value (-1) for interpolated bins.
}
}
\note{
\itemize{
\item CODAR's SeaSonde R8 Radial Config Setup documentation advises against using 3x or 4x interpolation.
\item The function ensures the number of Doppler bins after interpolation does not exceed 2048.
\item Doppler interpolation is a preprocessing step typically performed by CODAR's AnalyzeSpectra tool before MUSIC processing.
}
}
\examples{
# Doppler interpolation
# Create a SeaSondeRCS object for interpolation example
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
# Perform Doppler interpolation
out <- seasonder_SeaSondeRCSMUSICInterpolateDoppler(cs_obj)
}
\seealso{
\code{\link{seasonder_setSeaSondeRCS_MUSIC_interpolated_data}} for setting interpolated data,
\code{\link{seasonder_getSeaSondeRCS_MUSIC_doppler_interpolation}} for retrieving the interpolation factor,
\code{\link{seasonder_setSeaSondeRCS_MUSIC_doppler_interpolation}} for setting the interpolation factor,
\code{\link{seasonder_initCSDataStructure}} for initializing the interpolated data structure.
}
