% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICTestDualSolutions}
\alias{seasonder_MUSICTestDualSolutions}
\title{Test Dual-Bearing Solutions Using MUSIC Algorithm}
\usage{
seasonder_MUSICTestDualSolutions(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC solutions and related data.}
}
\value{
The updated SeaSondeRCS object with validated dual-bearing solutions and recorded processing steps.
}
\description{
This function applies a sequence of tests (P1, P2, and P3) to validate dual-bearing solutions
derived using the MUSIC algorithm. The tests evaluate the quality of solutions based on
eigenvalue ratios, signal power ratios, and covariance matrix power ratios.
}
\details{
The function applies the following sequence of tests:
\enumerate{
\item \strong{P1: Eigenvalue Ratio Test}:
\itemize{
\item Evaluates the ratio between the largest and second-largest eigenvalues.
}
\item \strong{P2: Signal Power Ratio Test}:
\itemize{
\item Validates the ratio of signal powers for dual-bearing solutions.
}
\item \strong{P3: Signal Matrix Power Ratio Test}:
\itemize{
\item Checks the ratio of diagonal to off-diagonal powers in the covariance matrix.
}
}

Each test updates the MUSIC solutions in the input object, marking solutions that fail the tests as "single."
The function also logs the start and end of the testing process as part of the object's processing steps.
}
\seealso{
\code{\link{seasonder_MUSICCheckEigenValueRatio}}, \code{\link{seasonder_MUSICCheckSignalPowers}},
\code{\link{seasonder_MUSICCheckSignalMatrix}}, \code{\link{seasonder_setSeaSondeRCS_ProcessingSteps}}
}
