% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICLonLat}
\alias{seasonder_MUSICLonLat}
\alias{seasonder_MUSIC_LonLat}
\title{Map MUSIC Bearings to Geographic Coordinates}
\usage{
seasonder_MUSICLonLat(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing MUSIC detection data.}
}
\value{
A \code{SeaSondeRCS} object with updated MUSIC data, including geographic coordinates for each detection.
}
\description{
This function calculates geographic coordinates (latitude and longitude) for each MUSIC detection based on the range and direction of arrival (DOA) bearings from a \code{SeaSondeRCS} object.
}
\details{
This function performs the following operations:
\enumerate{
\item Retrieves MUSIC data and original geographic coordinates (latitude and longitude) from the \code{seasonder_cs_object}. If these coordinates are not available, the origin is derived from the associated Antenna Pattern (APM) data.
\item Converts DOA bearings from MUSIC detections into geographic bearings using the APM object.
\item Computes latitude and longitude for each MUSIC detection based on the range and geographic bearings using \code{\link{seasonder_computeLonLatFromOriginDistBearing}}
\item Updates the \code{seasonder_cs_object} with the newly computed coordinates.
}
}
\examples{
# Create a SeaSondeRCS object for MUSIC example
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj  <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj   <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
cs_obj <- seasonder_initMUSICData(
 cs_obj,
 range_cells = c(rep(5,11), rep(4,11)),
 doppler_bins = c(c(669:679),c(674:684))
)
cs_obj <- seasonder_runMUSIC(cs_obj)
updated_obj <- seasonder_MUSICLonLat(cs_obj)
print(updated_obj)
}
\seealso{
\itemize{
\item \code{\link{seasonder_getSeaSondeRCS_MUSIC}}
\item \code{\link{seasonder_getSeaSondeRCS_APM}}
\item \code{\link{seasonder_MUSICBearing2GeographicalBearing}}
\item \code{\link{seasonder_computeLonLatFromOriginDistBearing}}
}
}
