% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICComputeDOAProjections}
\alias{seasonder_MUSICComputeDOAProjections}
\title{Compute DOA Functions Using the MUSIC Algorithm}
\usage{
seasonder_MUSICComputeDOAProjections(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{An object representing the cross-spectra (CS) data from SeaSonde.}
}
\value{
The updated \code{seasonder_cs_object} with the MUSIC DOA functions computed and appended.
}
\description{
This function calculates the Direction of Arrival (DOA) functions based on the MUSIC algorithm
for a given SeaSonde cross-spectra (CS) object. It projects the antenna patterns onto the noise
subspace for each Doppler bin and computes single and dual signal solutions, following the MUSIC method.
}
\details{
The function operates as follows:
\enumerate{
\item It sets a processing step indicating the start of DOA function computation.
\item Retrieves the Antenna Pattern Measurement (APM) and bearings associated with the CS object.
\item Iteratively computes projections of antenna pattern responses into the noise subspace for each
Doppler bin using the MUSIC algorithm. This includes:
\itemize{
\item Initializing storage for projection results.
\item Calculating projections for single (m = 1) and dual (m = 2) signal solutions using
the eigenvectors defining the noise subspace.
\item For each bearing, projecting the antenna manifold vector onto the noise subspace,
as described by the formula:
\deqn{DOA(\theta) = \frac{1}{A^*(\theta) E_n E_n^* A(\theta)}}
where:
\itemize{
\item \eqn{E_n} is the eigenvector matrix of the noise subspace.
\item \eqn{A(\theta)} is the antenna pattern response vector at bearing \eqn{\theta}.
\item \eqn{A^*(\theta)} is its conjugate transpose.
}
}
\item Appends the computed DOA functions to the MUSIC data of the CS object.
\item Updates the processing step to indicate completion.
}
}
\section{References}{

\itemize{
\item Paolo, T. de, Cook, T., & Terrill, E. (2007). Properties of HF RADAR Compact Antenna Arrays and Their Effect on the MUSIC Algorithm. \emph{OCEANS 2007}, 1–10. doi:10.1109/oceans.2007.4449265.
}
}

\seealso{
\code{\link{seasonder_compute_antenna_pattern_proyections}} for computing projections.
}
