% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_DopplerFreq2NormalizedDopplerFreq}
\alias{seasonder_DopplerFreq2NormalizedDopplerFreq}
\title{Convert Doppler Frequencies to Normalized Doppler Frequencies}
\usage{
seasonder_DopplerFreq2NormalizedDopplerFreq(
  seasonder_cs_object,
  doppler_values
)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeR} cross-spectral object containing metadata about the Doppler bins.}

\item{doppler_values}{A numeric vector specifying the Doppler frequencies (in Hz) to be converted into normalized Doppler frequencies.}
}
\value{
A numeric vector of normalized Doppler frequencies corresponding to the input Doppler values.
}
\description{
This function converts Doppler frequencies (in Hz) into their corresponding normalized Doppler frequencies within a \code{SeaSondeR} object.
}
\details{
The function follows these steps:
\enumerate{
\item Calls \code{\link{seasonder_DopplerFreq2Bins}} to convert the input Doppler frequencies into Doppler bin indices.
\item Calls \code{\link{seasonder_Bins2NormalizedDopplerFreq}} to obtain the corresponding normalized Doppler frequencies.
}

The normalized Doppler frequency is computed as:
\deqn{f_{doppler} = f_{norm} \times f_{bragg}}
where:
\itemize{
\item \eqn{f_{doppler}} is the Doppler frequency in Hz,
\item \eqn{f_{norm}} is the normalized Doppler frequency,
\item \eqn{f_{bragg}} is the Bragg frequency, computed based on radar wavelength.
}

This function ensures consistency by mapping input frequencies to their closest bin representation before normalization.
}
\seealso{
\code{\link{seasonder_DopplerFreq2Bins}} for converting Doppler frequencies to bin indices.
\code{\link{seasonder_Bins2NormalizedDopplerFreq}} for converting bin indices to normalized frequencies.
}
