% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_DopplerFreq2Bins}
\alias{seasonder_DopplerFreq2Bins}
\title{Convert Doppler Frequencies to Doppler Bins}
\usage{
seasonder_DopplerFreq2Bins(seasonder_cs_object, doppler_values)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeR} cross-spectral object containing metadata about the Doppler bins.}

\item{doppler_values}{A numeric vector specifying the Doppler frequencies to be converted into bin indices.}
}
\value{
An integer vector of Doppler bin indices corresponding to the input Doppler frequencies. Values that fall outside the valid bin range are assigned \code{NA}.
}
\description{
This function converts a set of Doppler frequency values into their corresponding Doppler bin indices within a \code{SeaSondeR} object.
}
\details{
This function first retrieves the Doppler frequency bins from the given \code{SeaSondeR} object using \code{\link{seasonder_getDopplerBinsFrequency}} in non-normalized form.
The spectral resolution, which defines the frequency step size (\eqn{\Delta f}), is obtained using \code{\link{seasonder_getDopplerSpectrumResolution}}.

The number of Doppler bins is then determined using \code{\link{seasonder_getnDopplerCells}}.

With this information, the function calls \code{\link{seasonder_computeDopplerFreq2Bins}} to determine the corresponding bin indices for each input Doppler frequency.
}
\seealso{
\code{\link{seasonder_Bins2NormalizedDopplerFreq}} for the reverse operation.
\code{\link{seasonder_computeDopplerFreq2Bins}} for the core computation logic.
}
