% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_Bins2DopplerFreq}
\alias{seasonder_Bins2DopplerFreq}
\title{Convert Doppler Bins to Doppler Frequencies}
\usage{
seasonder_Bins2DopplerFreq(seasonder_cs_object, bins)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeR} cross-spectral object containing Doppler bin metadata.}

\item{bins}{A numeric vector specifying the Doppler bin indices.}
}
\value{
A numeric vector of Doppler frequencies (in Hz) corresponding to the specified bins.
}
\description{
This function retrieves the Doppler frequency values corresponding to the specified bin indices in a given \code{SeaSondeR} object.
}
\details{
This function retrieves the full set of Doppler bin frequencies using \code{\link{seasonder_getDopplerBinsFrequency}} in non-normalized form.
It then selects the Doppler frequencies corresponding to the specified bin indices.
}
\seealso{
\code{\link{seasonder_DopplerFreq2Bins}} for the reverse operation.
\code{\link{seasonder_getDopplerBinsFrequency}} for retrieving the full set of Doppler frequencies.
}
