% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cens_id.R
\name{cens_id}
\alias{cens_id}
\alias{cens_id.swmpr}
\title{Flag observations above/below detection limits}
\usage{
cens_id(swmpr_in, ...)

\method{cens_id}{swmpr}(swmpr_in, flag_type = "both", select = NULL, ...)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{optional arguments passed to or from other methods}

\item{flag_type}{chr string indicating the flag type to return, must be one of \code{'below'}, \code{'above'}, or \code{'both'}, see details}

\item{select}{chr string of parameters to keep, defaults to all, \code{'datetimestamp'} will always be kept}
}
\value{
Returns a swmpr object with additional columns for censored flag values and the appropriate flag type based on the input arguments.  Censored flag columns are named with a \code{c_} prefix.
}
\description{
Flag observations above/below detection limits
}
\details{
Censored observations are identified in swmpr objects using the CDMO flags -4 or -5, indicating outside the low or high sensor range, respectively.  Additional codes are identified including A (-2007) or SUL (2007-) for above and B (-2007), SBL (2007-), SCB (2007-, calculated) for below detection limits.   The QAQC columns are searched for all parameters and replaced with the appropriate value indicating the detection limit as defined by \code{flag_type}.  The default argument \code{flag_type = 'both'} will recode the QAQC columns as -1, 0, or 1 indicating below, within, or above the detection limit.  Setting \code{flag_type = 'below'} or \code{'above'} will convert the columns to \code{TRUE}/\code{FALSE} values indicating observations beyond the detection limit (either above or below, \code{TRUE}) or within the normal detection range \code{FALSE}. 
The output includes additional columns similar to those for QAQC flags, such that the column names for censored flags include a \code{c_} prefix before the parameter name.  Note that the function will of course not work if already processed with \code{\link{qaqc}}.  QAQC columns are retained for additional processing.

The user should refer to the metadata or visually examine the observed data to identify the actual limit, which may change over time.
}
\examples{
## get data
data(apacpnut)
dat <- apacpnut

## convert all qaqc columns to censored flags, -1 below, 0 within, 1 above
cens_id(dat)

## T/F for above or within, note that none are above
cens_id(dat, flag_type = 'above')

## T/F for below or within
cens_id(dat, flag_type = 'below')
}
\seealso{
\code{\link{qaqc}}
}
\concept{organize}
