% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_hobo_data.R
\name{tidy_hobo_data}
\alias{tidy_hobo_data}
\title{tidy_hobo_data}
\usage{
tidy_hobo_data(infile, outfile = FALSE, convert_utc = TRUE)
}
\arguments{
\item{infile}{filename (including path or URL if needed) for a raw CSV file exported from HOBOware.}

\item{outfile}{filename (including path if needed) to save the tidied data frame. Defaults to \code{FALSE}, in which case tidied data will not be saved.}

\item{convert_utc}{a logical argument indicating whether the user would like to convert from the time zone associated with their CSV to UTC}
}
\value{
a tidied data frame with the following column names: \code{datetime}, \code{condUncal} (uncalibrated conductivity, units: lux), \code{tempC} (temperature, units: degrees Celsius).
}
\description{
This function loads raw HOBO STIC CSV files and cleans up columns and headers
}
\examples{
clean_data <-
  tidy_hobo_data(
    infile = "https://samzipper.com/data/raw_hobo_data.csv",
    outfile = FALSE, convert_utc = TRUE
  )
head(clean_data)

}
