% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{for_breakdown}
\alias{for_breakdown}
\title{for_breakdown}
\usage{
for_breakdown(
  decomp_table,
  group,
  threshold,
  inc_died = TRUE,
  ldiff = 0.005,
  ci = 0.95,
  xlimit = c(-0.05, 0.35),
  ylimit = c(-0.04, 0.04)
)
}
\arguments{
\item{decomp_table}{matrix for group; see specification in description}

\item{group}{name of group}

\item{threshold}{cutoff, rounded to nearest 0.05}

\item{inc_died}{set to TRUE to include a second panel showing 'death' type admissions}

\item{ldiff}{specifically label points this far from xy line}

\item{ci}{set to a value <1 to draw confidence intervals at that value, or FALSE to not draw confidence intervals.}

\item{xlimit}{limits for x axis; default c(-0.05,0.35)}

\item{ylimit}{limits for y axis; default c(-0.04,0.04)}
}
\value{
ggplot figure (invisible)
}
\description{
For a given category (e.g., 'male', 'over 65') considers
\enumerate{
\item all admissions for people in that category
\item all admissions for people in that category for which the
SPARRA score was less than some threshold (e.g., false
negatives
}
}
\details{
For each of these groups, we consider the breakdown of medical
admission types. We then plot the frequency of admission types
in group 1 against the difference in frequencies between group
1 and group 2 (group 2 minus group 1).
An admission type which is relatively more common in group (1)
indicates that, in the relevant category, the admission type
tends to be associated with higher SPARRA scores (and is in a
sense easier to predict). Such admission types will correspond
to points below the line y=0.
Admission types which are relatively more common in group 2
correspond to those which are relatively harder to predict.
These correspond to points above the line y=0
Since points are close together, only those greater than a
certain distance from 0 are marked.

Takes as an argument a matrix in which
The matrix shows only data for the group in question
Columns are named with the admission types to be plotted. Any admission
types including the string 'Died' are counted as deaths
If the matrix has N rows, these are interpreted as corresponding to N
score quantiles in increasing order.
The (i,j)th entry of the matrix is the number of people admitted for
reason i with a score greater than or equal to (j-1)/N and less than (j/N)
who are in that group
}
\examples{

# See vignette
}
