% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_AreaUnderTheCurve.R
\name{auc.xy}
\alias{auc.xy}
\title{Area under the curve}
\usage{
## Generic S3 method
auc.xy(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=auc.xy.numeric]{auc.xy.numeric}}
  \describe{
    \item{\code{y,x}}{A pair of <\link{double}> vectors of \link{length} \eqn{n}.}
    \item{\code{method}}{A <\link{integer}> value (default: \eqn{0}). Defines the underlying method of calculating the area under the curve. If \eqn{0} it is calculated using the \code{trapezoid}-method, if \eqn{1} it is calculated using the \code{step}-method.}
    \item{\code{presorted}}{A <\link{logical}>-value \link{length} 1 (default: \link{FALSE}). If \link{TRUE} the input will not be sorted by threshold.}
  }}
}
\value{
A <\link{double}> value.
}
\description{
The \code{\link[=auc.xy]{auc.xy()}}-function calculates the area under the curve.
}
\section{Definition}{


\strong{Trapezoidal rule}

The \strong{trapezoidal rule} approximates the integral of a function \eqn{f(x)} between
\eqn{x = a} and \eqn{x = b} using trapezoids formed between consecutive points. If
we have points \eqn{x_0, x_1, \ldots, x_n} (with \eqn{a = x_0 < x_1 < \cdots < x_n = b})
and corresponding function values \eqn{f(x_0), f(x_1), \ldots, f(x_n)}, the area under
the curve \eqn{A_T} is approximated by:

\deqn{
  A_T \approx \sum_{k=1}^{n} \frac{f(x_{k-1}) + f(x_k)}{2} \bigl[x_k - x_{k-1}\bigr].
}

\strong{Step-function method}

The \strong{step-function (rectangular) method} uses the value of the function at one
endpoint of each subinterval to form rectangles. With the same partition
\eqn{x_0, x_1, \ldots, x_n}, the rectangular approximation \eqn{A_S} can be written as:

\deqn{
  A_S \approx \sum_{k=1}^{n} f(x_{k-1}) \bigl[x_k - x_{k-1}\bigr].
}
}

\concept{Tools}
