% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaintegerOnePointCrossover.R
\name{gaintegerOnePointCrossover}
\alias{gaintegerOnePointCrossover}
\title{One-point crossover operator for integer-encoded genetic algorithms}
\usage{
gaintegerOnePointCrossover(object, parents, ...)
}
\arguments{
\item{object}{A GA object with a \code{@population} slot (a matrix).}

\item{parents}{A 2-row matrix of values indexing the parents from the current population.}

\item{...}{Further arguments (unused, included for compatibility).}
}
\value{
A list with two elements:
\describe{
\item{children}{A 2-row matrix of the resulting offspring.}
\item{fitness}{A numeric vector of \code{NA} values to be replaced by fitness evaluation.}
}
}
\description{
Performs one-point crossover on two parent individuals. A single crossover point is selected,
and all genes before (and including) that point are exchanged between the parents.
}
