% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shark_read.R
\name{read_shark_deliv}
\alias{read_shark_deliv}
\title{Read SHARK Excel delivery files (.xls or .xlsx)}
\usage{
read_shark_deliv(filename, skip = 2, sheet = 2)
}
\arguments{
\item{filename}{Path to the Excel file to be read.}

\item{skip}{Minimum number of rows to skip before reading anything (column names or data).
Leading empty rows are automatically skipped, so this is a lower bound.
Ignored if \code{sheet} or \code{range} specifies a starting row. Default is 2.}

\item{sheet}{Sheet to read. Either a string (sheet name) or integer (sheet index).
If neither is specified, defaults to the second sheet.}
}
\value{
A data frame containing the parsed contents of the Excel file, or \code{NULL} if the file
does not exist, is empty, or cannot be read.
}
\description{
Reads Excel files delivered to SHARK in a standardized format.
The function automatically detects whether the file is \code{.xls} or \code{.xlsx}
and reads the specified sheet, skipping a configurable number of rows.
Column types are automatically converted, and if a column \code{"SDATE"} exists,
it is converted to \code{Date}.
}
\examples{
\dontrun{
# Read the second sheet of a .xlsx file (default)
df_xlsx <- read_shark_deliv("shark_delivery.xlsx")

# Read the first sheet of a .xls file, skipping 3 rows
df_xls <- read_shark_deliv("shark_delivery.xls", skip = 3, sheet = 1)
}

}
\seealso{
\code{\link[=read_shark]{read_shark()}} for reading SHARK tab- or semicolon-delimited export files or zip-archives.
}
