% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyntaxa_api_functions.R
\name{match_dyntaxa}
\alias{match_dyntaxa}
\title{Taxon matching using Dyntaxa (https://www.dyntaxa.se/)}
\usage{
match_dyntaxa(names, subscription_key = Sys.getenv("DYNTAXA_KEY"))
}
\arguments{
\item{names}{Character vector of scientific names to check in Dyntaxa.}

\item{subscription_key}{A Dyntaxa API subscription key. By default, the key
is read from the environment variable \code{DYNTAXA_KEY}.}
}
\value{
A logical vector indicating whether each input name was found in Dyntaxa,
same as \code{\link[=is_in_dyntaxa]{is_in_dyntaxa()}}. Messages about unmatched taxa are printed.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is deprecated and has been replaced by \code{\link[=is_in_dyntaxa]{is_in_dyntaxa()}}.
}
\details{
This function is retained for backward compatibility but may be removed in future versions.
Use the newer function \code{\link[=is_in_dyntaxa]{is_in_dyntaxa()}} instead.

A valid Dyntaxa API subscription key is required.
You can request a free key for the "Taxonomy" service from the ArtDatabanken API portal:
\url{https://api-portal.artdatabanken.se/}
}
\examples{
\dontrun{
# Deprecated function usage
match_dyntaxa(c("Skeletonema marinoi", "Nonexistent species"),
              subscription_key = "your_key_here")
}

}
\keyword{internal}
