% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyntaxa_api_functions.R
\name{is_in_dyntaxa}
\alias{is_in_dyntaxa}
\title{Check if taxon names exist in Dyntaxa}
\usage{
is_in_dyntaxa(
  taxon_names,
  subscription_key = Sys.getenv("DYNTAXA_KEY"),
  use_dwca = FALSE,
  return_df = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{taxon_names}{Character vector of taxon names to check.}

\item{subscription_key}{A Dyntaxa API subscription key. By default, the key
is read from the environment variable \code{DYNTAXA_KEY}.

You can provide the key in three ways:
\itemize{
\item \strong{Directly as a parameter}:
\code{is_in_dyntaxa("Skeletonema marinoi", subscription_key = "your_key_here")}.
\item \strong{Temporarily for the session}:
\code{Sys.setenv(DYNTAXA_KEY = "your_key_here")}.
After this, you do not need to pass \code{subscription_key} to the function.
\item \strong{Permanently across sessions} by adding it to your \code{~/.Renviron} file.
Use \code{usethis::edit_r_environ()} to open the file, then add:
\code{DYNTAXA_KEY=your_key_here}.
After this, you do not need to pass \code{subscription_key} to the function.
}}

\item{use_dwca}{Logical; if TRUE, uses the DwCA version of Dyntaxa instead of querying the API.}

\item{return_df}{Logical; if TRUE, returns a data frame with columns \code{taxon_name},
\code{taxon_id}, and \code{match}. Default is FALSE (returns a logical vector).}

\item{verbose}{Logical; if TRUE, prints messages about unmatched taxa.}
}
\value{
If \code{return_df = FALSE} (default), a logical vector indicating whether each input
name was found in Dyntaxa. Returned invisibly if \code{verbose = TRUE}.
If \code{return_df = TRUE}, a data frame with columns:
\itemize{
\item \code{taxon_name}: original input names
\item \code{taxon_id}: corresponding Dyntaxa taxon IDs (NA if not found)
\item \code{match}: logical indicating presence in Dyntaxa
}
}
\description{
Checks whether the supplied scientific names exist in the
Swedish taxonomic database Dyntaxa. Optionally, returns a data frame
with taxon names, taxon IDs, and match status.
}
\details{
A valid Dyntaxa API subscription key is required.
You can request a free key for the "Taxonomy" service from the ArtDatabanken API portal:
\url{https://api-portal.artdatabanken.se/}
}
\examples{
\dontrun{
# Using an environment variable (recommended for convenience)
Sys.setenv(DYNTAXA_KEY = "your_key_here")
is_in_dyntaxa(c("Skeletonema marinoi", "Nonexistent species"))

# Return a data frame instead of logical vector
is_in_dyntaxa(c("Skeletonema marinoi", "Nonexistent species"), return_df = TRUE)

# Or pass the key directly
is_in_dyntaxa("Skeletonema marinoi", subscription_key = "your_key_here")

# Suppress messages
is_in_dyntaxa("Skeletonema marinoi", verbose = FALSE)
}

}
