% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worms_api_functions.R
\name{get_worms_records_name}
\alias{get_worms_records_name}
\title{Retrieve WoRMS records by taxonomic names with retry logic}
\usage{
get_worms_records_name(
  taxa_names,
  fuzzy = TRUE,
  best_match_only = TRUE,
  max_retries = 3,
  sleep_time = 10,
  marine_only = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{taxa_names}{A vector of taxonomic names for which to retrieve records.}

\item{fuzzy}{A logical value indicating whether to search using a fuzzy search pattern. Default is TRUE.}

\item{best_match_only}{A logical value indicating whether to automatically select the first match and return a single match. Default is TRUE.}

\item{max_retries}{An integer specifying the maximum number of retries for the request in case of failure. Default is 3.}

\item{sleep_time}{A numeric value specifying the number of seconds to wait before retrying a failed request. Default is 10.}

\item{marine_only}{A logical value indicating whether to restrict the results to marine taxa only. Default is \code{FALSE}.}

\item{verbose}{A logical indicating whether to print progress messages. Default is TRUE.}
}
\value{
A \code{tibble} containing the retrieved WoRMS records. Each row corresponds to a record for a taxonomic name.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function has been deprecated. Users are encouraged to use \code{\link{match_worms_taxa}} instead.

This function retrieves records from the WoRMS database using the \code{worrms} R package for a vector of taxonomic names.
It includes retry logic to handle temporary failures and ensures all names are processed.
}
\details{
The function attempts to retrieve records for the input taxonomic names using the \code{wm_records_names} function from the WoRMS API.
If a request fails, it retries up to \code{max_retries} times, pausing for \code{sleep_time} seconds between attempts.
If all attempts fail, the function stops and throws an error.
}
\examples{
\donttest{
# Retrieve WoRMS records for the taxonomic names "Amphidinium" and "Karenia"
records <- get_worms_records_name(c("Amphidinium", "Karenia"),
                                  max_retries = 3, sleep_time = 5, marine_only = TRUE)
}

}
\seealso{
\url{https://marinespecies.org/} for WoRMS website.

\url{https://CRAN.R-project.org/package=worrms}
}
\keyword{internal}
