% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nua_api_functions.R
\name{get_nua_external_links}
\alias{get_nua_external_links}
\title{Retrieve external links or facts for taxa from Nordic Microalgae}
\usage{
get_nua_external_links(slug, verbose = TRUE, unparsed = FALSE)
}
\arguments{
\item{slug}{A vector of taxon slugs (identifiers) for which to retrieve external links.}

\item{verbose}{A logical flag indicating whether to display a progress bar. Default is \code{TRUE}.}

\item{unparsed}{Logical. If \code{TRUE}, the API response with all facts is returned as an unparsed list. Default is \code{FALSE}.}
}
\value{
When unparsed = \code{FALSE}: a \code{tibble} containing the following columns:
\item{slug}{The slug (identifier) of the taxon.}
\item{provider}{The provider of the external link.}
\item{label}{The label of the external link.}
\item{external_id}{The external ID associated with the external link.}
\item{external_url}{The URL of the external link.}
\item{collection}{The collection category, which is "External Links" for all rows.}
}
\description{
This function retrieves external links related to algae taxa from the Nordic Microalgae API.
It takes a vector of slugs (taxon identifiers) and returns a data frame containing the external links
associated with each taxon. The data includes the provider, label, external ID, and the URL of the external link.
}
\details{
The slugs (taxon identifiers) used in this function can be retrieved using the \code{get_nua_taxa()} function,
which returns a data frame with a column for taxon slugs, along with other relevant metadata for each taxon.
}
\examples{
\donttest{
  # Retrieve external links for a vector of slugs
  external_links <- get_nua_external_links(slug = c("chaetoceros-debilis", "alexandrium-tamarense"),
                                           verbose = FALSE)
  head(external_links)
}
}
\seealso{
\url{https://nordicmicroalgae.org/} for Nordic Microalgae website.

\url{https://nordicmicroalgae.org/api/} for Nordic Microalgae API documentation.
}
