% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.SDTree}
\alias{plot.SDTree}
\title{Plot SDTree}
\usage{
\method{plot}{SDTree}(x, main = "", digits = 2, digits_decisions = 2, weighted = TRUE, ...)
}
\arguments{
\item{x}{Fitted object of class \code{SDTree}.}

\item{main}{title for the tree}

\item{digits}{integer indicating the number of decimal places to round() the 
leaf values to}

\item{digits_decisions}{integer indicating the number of decimal places to 
round() the splitting rule to.}

\item{weighted}{if true, connections from parent to children is scaled with res_dloss,
more important splits result in thicker lines.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A ggplot object
}
\description{
Plot the SDTree.
}
\seealso{
\code{\link{SDTree}}
set.seed(1)
n <- 10
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + rnorm(n)
model <- SDTree(x = X, y = y, Q_type = 'no_deconfounding', cp = 0.5)
plot(model)
}
\author{
Markus Ulmer
}
