% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatReg_Extract.R
\name{SpatReg_Extract}
\alias{SpatReg_Extract}
\title{Extracts numerical values for the estimated regression parameters (i.e., spatial coefficients, regression coefficients, and residuals variance) for a given spatial regression model of class \code{lm} or \code{Sarlm}.}
\usage{
SpatReg_Extract(SRModel)
}
\arguments{
\item{SRModel}{Estimated spatial or non-spatial regression model of class \code{lm} or \code{Sarlm} (see package \code{spatialreg} for details.)}
}
\value{
A named \code{vector} containing numerical values for the estimated spatial parameters (e.g.,  \eqn{\rho} in SAR or  \eqn{\lambda} in SEM), regression coefficients, and residuals variance for the input model in \code{SRModel}.
}
\description{
Extracts the numerical values for the regression parameters (i.e., estimated spatial parameters, regression coefficients, and residuals variance) for a given spatial regression model of class \code{lm} or \code{Sarlm} as defined in package \code{spatialreg}.
The function can be applied to the output of any SCSR model and contained in the \code{ClusterFitModels} output of \code{SCSR_Estim} function.
}
\examples{
data(Data_RC_PM_RM_JABES2024, package="SCDA")
SCSAR <- SCSR_Estim(Formula = "Gini_SO ~ GDPPC_PPS2020 + Share_AgroEmp",
                    Data_sf = Data2020, G=3, listW=listW, Type="SCSAR", Phi = 0.50)
SpatReg_Extract(SRModel = SCSAR$ClusterFitModels[[1]])
SpatReg_Extract(SRModel = SCSAR$ClusterFitModels[[2]])
SpatReg_Extract(SRModel = SCSAR$ClusterFitModels[[3]])

}
