% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{psubbo}
\alias{psubbo}
\title{Returns CDF from Subbotin Distribution}
\usage{
psubbo(x, m = 0, a = 1, b = 2)
}
\arguments{
\item{x}{(numeric) - value in the range \eqn{(-\infty, \infty)} to evaluate
the density.}

\item{m}{(numeric) - location parameter.}

\item{a}{(numeric) - scale parameter. Must be in the range \eqn{(0, \infty)}.}

\item{b}{(numeric) - shape parameter. Must be in the range \eqn{(0, \infty)}.}
}
\value{
a vector containing the values for the probabilities.
}
\description{
The \code{psubbo} returns the Cumulative Distribution Function (CDF) from the
the Subbotin evaluated at \eqn{a} and return \eqn{z}, such that
\eqn{P(X < a) = z}.
}
\details{
The Subbotin cumulative distribution function is given by:
\deqn{F(x;a,b,m) = 0.5 + 0.5 \text{sign}(x -m)P(x, 1/b)}
where \eqn{P} is the normalized incomplete gamma function:
\deqn{P(x, 1/b) = 1 - \frac{1}{\Gamma(1/b)} \int_{0}^{x} t^{1/b -1}e^{-t} }
and \eqn{a} is a scale parameter, \eqn{b} controls the tails (lower values
represent fatter tails), and \eqn{m} is a location parameter.
}
