% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_multivariate_corr_cov.R
\name{weighted.corr.cov.n}
\alias{weighted.corr.cov.n}
\title{Multivariate correlation and covariance}
\usage{
weighted.corr.cov.n(
  data,
  x,
  w = rep(1, length(data[x[1]])),
  corr = TRUE,
  na.rm = TRUE
)
}
\arguments{
\item{data}{(data frame) Data to analyse}

\item{x}{(string vector) Variables of interest for which to compute the correlation/covariance}

\item{w}{(string) Name of the numeric variable representing the weights}

\item{corr}{(bool) if TRUE: Computes correlation; if FALSE: Computes covariance}

\item{na.rm}{(bool) if TRUE: Excludes missing values before computing the correlation/covariance.}
}
\value{
Data frame containing each pairwise bivariate correlation/covariance
}
\description{
Computes multivariate correlation and covariance for the variables of interest.
}
\examples{
data(df_talis18)

weighted.corr.cov.n(df_talis18,c("t3stake","t3team","t3stud"),"tchwgt")

}
