% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{hyper_names}
\alias{hyper_names}
\title{Get correct hyperparameter names}
\usage{
hyper_names(adstock, all_media, all_vars = NULL)
}
\arguments{
\item{adstock}{Character. Default to \code{InputCollect$adstock}.
Accepts "geometric", "weibull_cdf" or "weibull_pdf"}

\item{all_media}{Character vector. Default to \code{InputCollect$all_media}.
Includes \code{InputCollect$paid_media_spends} and \code{InputCollect$organic_vars}.}

\item{all_vars}{Used to check the penalties inputs, especially for refreshing models.}
}
\value{
Character vector. Names of hyper-parameters that should be defined.
}
\description{
Output all hyperparameter names and help specifying the list of
hyperparameters that is inserted into \code{robyn_inputs(hyperparameters = ...)}
}
\section{Guide to setup hyperparameters}{

See section "Hyperparameter interpretation & recommendation" in demo
https://github.com/facebookexperimental/Robyn/blob/main/demo/demo.R
}

\section{Helper plots}{

\describe{
  \item{plot_adstock(TRUE)}{Get adstock transformation example plot,
helping you understand geometric/theta and weibull/shape/scale transformation}
  \item{plot_saturation(TRUE)}{Get saturation curve transformation example plot,
helping you understand hill/alpha/gamma transformation}
}
}

\examples{
\donttest{
media <- c("facebook_I", "print_S", "tv_S")
hyper_names(adstock = "geometric", all_media = media)

hyperparameters <- list(
  facebook_I_alphas = c(0.5, 3), # example bounds for alpha
  facebook_I_gammas = c(0.3, 1), # example bounds for gamma
  facebook_I_thetas = c(0, 0.3), # example bounds for theta
  print_S_alphas = c(0.5, 3),
  print_S_gammas = c(0.3, 1),
  print_S_thetas = c(0.1, 0.4),
  tv_S_alphas = c(0.5, 3),
  tv_S_gammas = c(0.3, 1),
  tv_S_thetas = c(0.3, 0.8)
)

# Define hyper_names for weibull adstock
hyper_names(adstock = "weibull_pdf", all_media = media)

hyperparameters <- list(
  facebook_I_alphas = c(0.5, 3), # example bounds for alpha
  facebook_I_gammas = c(0.3, 1), # example bounds for gamma
  facebook_I_shapes = c(0.0001, 2), # example bounds for shape
  facebook_I_scales = c(0, 0.1), # example bounds for scale
  print_S_alphas = c(0.5, 3),
  print_S_gammas = c(0.3, 1),
  print_S_shapes = c(0.0001, 2),
  print_S_scales = c(0, 0.1),
  tv_S_alphas = c(0.5, 3),
  tv_S_gammas = c(0.3, 1),
  tv_S_shapes = c(0.0001, 2),
  tv_S_scales = c(0, 0.1)
)
}
}
