% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-harmo_process_harmonization.R
\name{show_harmo_error}
\alias{show_harmo_error}
\title{Print a summary of data processing in the console}
\usage{
show_harmo_error(harmonized_dossier, show_warnings = TRUE)
}
\arguments{
\item{harmonized_dossier}{A list containing the harmonized dataset(s).}

\item{show_warnings}{Whether the function should print warnings or not.
TRUE by default.}
}
\value{
Nothing to be returned. The function prints messages in the console,
showing any errors in data processing.
}
\description{
Reads a harmonized dossier, product of \code{\link[=harmo_process]{harmo_process()}}, to list processes,
any errors, and an overview of each harmonization rule. The output printed
in the console can help in correcting any errors that occurred during
data processing.
}
\details{
A harmonized dossier is a named list containing one or more data frames,
which are harmonized datasets. A harmonized dossier is generally the
product of applying processing to a dossier object The name of each
harmonized dataset (data frame) is taken from the reference input dataset.
A harmonized dossier also contains the DataSchema and
Data Processing Elements used in processing as attributes.
}
\examples{
{
# Use Rmonize_examples to run examples.
library(dplyr)

# Perform data processing
harmonized_dossier <- Rmonize_examples$`harmonized_dossier`

# Show error(s) on the console
show_harmo_error(harmonized_dossier)
}

}
