% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hierarchical_clustering.R
\name{hclust_hurst}
\alias{hclust_hurst}
\title{Hierarchical clustering}
\usage{
hclust_hurst(
  X.t,
  k = NULL,
  h = NULL,
  dist.method = "euclidean",
  method = "complete",
  dendrogram = FALSE,
  N = 100,
  Q = 2,
  L = 2
)
}
\arguments{
\item{X.t}{A list of data frames. In each data frame, the first column is a numeric time sequence
and the second gives the values of the processes or time series. To get reliable results, it is
recommended to use at least 500 time points. See Examples for usage.}

\item{k}{The desired number of clusters.}

\item{h}{The height where the dendrogram should be cut into. Either \code{k} or \code{h} must be specified. If both are provided k is used.}

\item{dist.method}{A string which specifies a registered distance from \code{\link[proxy:dist]{proxy::dist()}}. The default
is \code{"euclidean"}.}

\item{method}{A string which specifies the hierarchical method used. Available methods
are \code{"ward.D"}, \code{"ward.D2"}, \code{"single"}, \code{"complete"}, \code{"average"}, \code{"mcquitty"}, \code{"median"} and \code{"centroid"}.
The default method is \code{"complete"}.}

\item{dendrogram}{Logical: If \code{TRUE} the dendrogram is plotted indicating
the clusters in interactive sessions.}

\item{N}{Argument used for the estimation of Hurst functions. Number of sub-intervals on which the estimation is performed on. Default is set to 100 sub-intervals.}

\item{Q}{Argument used for the estimation of Hurst functions. Fixed integer greater than or equal to 2. Default is set to 2.}

\item{L}{Argument used for the estimation of Hurst functions. Fixed integer greater than or equal to 2. Default is set to 2.}
}
\value{
An object list of class \code{"hc_hurst"} with print and plot methods. The list has following components:
\describe{
\item{\code{cluster_info}}{A data frame indicating the cluster number and distance to cluster center from
each smoothed estimated Hurst function (item). Distance is obtained from the \code{dist.method}.}
\item{\code{cluster}}{A vector with cluster number of each item.}
\item{\code{cluster_sizes}}{Number of items in each cluster.}
\item{\code{centers}}{A data frame of cluster centers. Center obtained as the average of each smoothed estimated Hurst function in the cluster.
Columns denote time points in which estimates were obtained. Row names denote cluster numbers.}
\item{\code{smoothed_Hurst_estimates}}{A data frame of smoothed Hurst estimates. Columns denote time points in which estimates were obtained.
Rows denote estimates for each realisation.}
\item{\code{raw_Hurst_estimates}}{A list of data frames of raw Hurst estimates.}
\item{\code{call}}{Information about the input parameters used.}
}
}
\description{
This function performs hierarchical clustering of realisations
based on the estimated Hurst functions.
}
\details{
The Hurst function of each realisation is estimated using the function \code{\link{Hurst}} and the smoothed Hurst estimates are used
for the cluster analysis. The distances between smoothed Hurst estimates are  computed by the \code{dist.method} provided and passed into
the \code{\link[stats]{hclust}} for hierarchical clustering.
}
\examples{
\donttest{
#Simulation of multifractional processes
t <- seq(0, 1, by = (1/2)^10)
H1 <- function(t) {return(0.1 + 0*t)}
H2 <- function(t) {return(0.2 + 0.45*t)}
H3 <- function(t) {return(0.5 - 0.4 * sin(6 * 3.14 * t))}
X.list.1 <- replicate(3, GHBMP(t,H1),simplify = FALSE)
X.list.2 <- replicate(3, GHBMP(t,H2),simplify = FALSE)
X.list.3 <- replicate(3, GHBMP(t,H3),simplify = FALSE)
X.list <- c(X.list.1, X.list.2, X.list.3)

#Hierarchical clustering based on k = 3 clusters with dendrogram plotted
HC <- hclust_hurst(X.list, k=3, dendrogram = TRUE)
print(HC)

#Plot of smoothed Hurst functions in each cluster with cluster centers
plot(HC,type = "ec")
}
}
\seealso{
\code{\link{print.hc_hurst}}, \code{\link{plot.hc_hurst}}, \code{\link{kmeans_hurst}}
}
