% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fforecast.R
\name{print.fforecast}
\alias{print.fforecast}
\title{Custom Print Method for FSSA Forecast (fforecast) class}
\usage{
\method{print}{fforecast}(x, ...)
}
\arguments{
\item{x}{an object of class "fforecast" to be printed.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This custom print method is designed for objects of the FSSA Forecast (fforecast) class.
It provides a summary of the fforecast object.
}
\examples{
# Example with one-dimensional domain
data("Callcenter")
# FSSA Decomposition step:
fssa_results <- fssa(Callcenter, L = 28)

# Perform FSSA R-forecasting
pr_R <- fforecast(U = fssa_results,
                  groups = c(1:3),
                  len = 14,
                  method = "recurrent")
print(pr_R)

}
