% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtotal_section.R
\name{subtotal_section}
\alias{subtotal_section}
\title{Subtotal Section Addition Function}
\usage{
subtotal_section(
  report,
  frame,
  vars = "Population",
  aggregator = "sum",
  exclude = numeric(0),
  agg_parameter = character(0),
  subtotal_label = "All"
)
}
\arguments{
\item{report}{A data report.}

\item{frame}{Data frame summarised by the data report.}

\item{vars}{Names of column(s) in the data frame aggregated in the data report.}

\item{aggregator}{Function to aggregate the data with.}

\item{exclude}{Vector of column indices determining which variables only require subtotal rows (as opposed to sections).}

\item{agg_parameter}{Optional parameter for the aggregation function to use.}

\item{subtotal_label}{Label to be used for subtotal rows.}
}
\value{
The data report with subtotal sections included.
}
\description{
Adds subtotal sections to a data report.
}
\details{
The dataset and report are factorized,
and a series of reports with the same variables are then generated,
but with some variables replaced by a subtotal label,
which effectively concentrates all levels of those variables
into one subtotal row for those variables - ultimately making up entire subtotal sections for some variables.
The subtotal reports are all combined with the original report,
and the combined report is sorted, sorting the subtotal label to the top for all variables.
}
\examples{
library(dplyr)

group_by(iris, Species) \%>\%
summarise(sum(Petal.Length), .groups = "keep") \%>\%
subtotal_section(iris, vars = "Petal.Length")

group_by(mtcars, cyl, gear) \%>\%
summarise(mean(mpg), .groups = "keep") \%>\%
subtotal_section(mtcars, vars = "mpg", aggregator = "mean")

group_by(mtcars, cyl, gear) \%>\%
summarise(mean(mpg), mean(wt), .groups = "keep") \%>\%
subtotal_section(mtcars, vars = c("mpg", "wt"),
aggregator = "mean", exclude = 1:2)

group_by(iris, Species, Petal.Width) \%>\%
summarise(max(Sepal.Width), max(Sepal.Length), .groups = "keep") \%>\%
subtotal_section(iris, vars = c("Sepal.Width", "Sepal.Length"),
aggregator = "max", agg_parameter = "na.rm")

group_by(mtcars, qsec, carb, hp, gear) \%>\%
summarise(min(cyl), min(drat), min(wt), .groups = "keep") \%>\%
subtotal_section(mtcars, vars = c("cyl", "drat", "wt"),
aggregator = "min", agg_parameter = "na.rm",
subtotal_label = "Cars_Total", exclude = c(1, 4))
}
