% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pIntrinsic.R
\name{pIntrinsic}
\alias{pIntrinsic}
\title{Computes the p-value for intrinsic credibility}
\usage{
pIntrinsic(
  p = z2p(z, alternative = alternative),
  z = NULL,
  alternative = c("two.sided", "one.sided", "less", "greater"),
  type = c("Held", "Matthews")
)
}
\arguments{
\item{p}{numeric vector of p-values.}

\item{z}{numeric vector of z-values. Default is \code{NULL}.}

\item{alternative}{Either "two.sided" (default) or "one.sided".
Specifies if the p-value is two-sided or one-sided.
If the p-value is one-sided, then a one-sided p-value for
intrinsic credibility is computed.}

\item{type}{Type of intrinsic p-value. Default is "Held" as in
Held (2019). The other option is "Matthews" as in Matthews (2018).}
}
\value{
p-values for intrinsic credibility.
}
\description{
Computes the p-value for intrinsic credibility
}
\examples{
p <- c(0.005, 0.01, 0.05)
pIntrinsic(p = p)
pIntrinsic(p = p, type = "Matthews")
pIntrinsic(p = p, alternative = "one.sided")
pIntrinsic(p = p, alternative = "one.sided", type = "Matthews")

pIntrinsic(z = 2)
}
\references{
Matthews, R. A. J. (2018). Beyond 'significance': principles and
    practice of the analysis of credibility. \emph{Royal Society Open
    Science}, \bold{5}, 171047. \doi{10.1098/rsos.171047}

Held, L. (2019). The assessment of intrinsic credibility and a new argument
for \emph{p < 0.005}. \emph{Royal Society Open Science}, \bold{6}, 181534.
\doi{10.1098/rsos.181534}
}
\author{
Leonhard Held
}
