% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scTrimClust.R
\name{scTrimClust}
\alias{scTrimClust}
\title{scTrimClust: Cluster visualization with alpha hull-based outlier detection}
\usage{
scTrimClust(
  object,
  dims = c(1, 2),
  cells = NULL,
  cols = NULL,
  pt.size = NULL,
  reduction = NULL,
  group.by = NULL,
  split.by = NULL,
  shape.by = NULL,
  order = NULL,
  shuffle = FALSE,
  seed = 1,
  label = FALSE,
  label.size = 4,
  label.color = "black",
  label.box = FALSE,
  repel = FALSE,
  alpha = 1,
  stroke.size = NULL,
  cells.highlight = NULL,
  cols.highlight = "#DE2D26",
  sizes.highlight = 1,
  na.value = "grey50",
  ncol = NULL,
  combine = TRUE,
  raster = NULL,
  raster.dpi = c(512, 512),
  add.alpha.hull = TRUE,
  hull.alpha = 2,
  hull.color = NULL,
  hull.size = 0.5,
  outlier.quantile = 0.4,
  remove.outliers = FALSE,
  outlier.alpha = 0.1,
  outlier.color = NULL,
  outlier.colors = NULL,
  outline.color = NULL,
  outline.size = 0.5,
  outline.alpha = 1,
  outline.outliers = FALSE
)
}
\arguments{
\item{object}{A Seurat object containing dimensionality reduction results.}

\item{dims}{Integer vector of length 2 specifying which dimensions to plot (e.g., c(1, 2)).}

\item{cells}{Vector of cells to include (NULL uses all cells).}

\item{cols}{Vector of colors for clusters.}

\item{pt.size}{Point size for cells.}

\item{reduction}{Name of dimensionality reduction to use (e.g., "umap", "tsne").}

\item{group.by}{Metadata column to group cells by (default: 'ident' uses cluster IDs).}

\item{split.by}{Metadata column to split plots by (creates multiple facets).}

\item{shape.by}{Metadata column to determine point shapes.}

\item{order}{Vector specifying order to plot cells (affects z-ordering).}

\item{shuffle}{Logical to randomly shuffle plotting order.}

\item{seed}{Random seed for reproducibility when shuffle=TRUE.}

\item{label}{Logical to add cluster labels.}

\item{label.size}{Size of cluster labels.}

\item{label.color}{Color of cluster labels.}

\item{label.box}{Logical to add background box to labels.}

\item{repel}{Logical to use ggrepel for label placement.}

\item{alpha}{Transparency level for points (0-1).}

\item{stroke.size}{Size of point borders.}

\item{cells.highlight}{Specific cells to highlight.}

\item{cols.highlight}{Color(s) for highlighted cells.}

\item{sizes.highlight}{Size(s) for highlighted cells.}

\item{na.value}{Color for NA values.}

\item{ncol}{Number of columns for faceted plots.}

\item{combine}{Logical to combine multiple plots into one.}

\item{raster}{Logical to rasterize points (for large datasets).}

\item{raster.dpi}{Resolution for rasterized points.}

\item{add.alpha.hull}{Logical to compute and plot alpha hulls.}

\item{hull.alpha}{Alpha parameter for hull calculation. Higher values produce smoother hulls
that encompass more cells (default: 2).}

\item{hull.color}{Color of the alpha hull lines (default: Null = same color as cluster points).}

\item{hull.size}{Thickness of the alpha hull lines (default: 0.5).}

\item{outlier.quantile}{Quantile threshold (0-1) for outlier detection based on hull distance.
Cells with distances below this quantile are considered outliers (default: 0.4).}

\item{remove.outliers}{Logical - whether to remove outliers from the returned Seurat object
(default: FALSE).}

\item{outlier.alpha}{Transparency level for outlier points (0-1; default: 0.1).}

\item{outlier.color}{Single color to use for all outlier points. If NULL, uses cluster colors.}

\item{outlier.colors}{A named vector of colors to be assigned to outliers.If NULL, uses cluster colors.}

\item{outline.color}{Color for the outline of points. If NULL, no outline is added.}

\item{outline.size}{Thickness of the outline around points (default: 0.5).}

\item{outline.alpha}{Transparency of the outline around points (default: 1).}

\item{outline.outliers}{Logical whether to add outlines to outlier points (default: FALSE).}
}
\value{
A list containing:
\itemize{
  \item \emph{plot}: ggplot object of the visualization with hulls and highlighted outliers
  \item \emph{object}: Modified Seurat object with outliers removed (if remove.outliers=TRUE)
  \item \emph{outlier_coords}: Dataframe containing coordinates of outlier cells, their IDs and cluster assignments
  \item \emph{hull_info}: List containing alpha hull geometries (if add.alpha.hull=TRUE)
}
}
\description{
Visualizes cell clusters in low-dimensional space (t-SNE, UMAP, etc.) and identifies/removes
potential outliers based on their distance from cluster alpha hulls.
}
\examples{
\dontrun{

scTrimClust(RepeatedHighDim:::seurat_obj,reduction = 'tsne',
group.by = 'CellType',
hull.alpha = 2,
remove.outliers = FALSE,
outlier.quantile = 0.2,
outlier.alpha = 0.3,
outlier.color = "red",
pt.size = 5,
outline.color = "black",
outline.outliers = TRUE)

# second example with custom outlier col per cluster

scTrimClust(RepeatedHighDim:::seurat_obj,reduction = 'tsne',
group.by = 'CellType',
hull.alpha = 2,
remove.outliers = FALSE,
outlier.quantile = 0.2,
outlier.alpha = 0.3,
outlier.colors = c('TypeA'="black",
'TypeB'='violet','TypeC' ='pink'),
pt.size = 5,
outline.color = "black",
outline.outliers = TRUE)$plot

}

}
