% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scTC_trim_effect.R
\name{scTC_trim_effect}
\alias{scTC_trim_effect}
\title{scTC_trim_effect: Compare scTrimClust trimming  against default Seurat analysis}
\usage{
scTC_trim_effect(
  method_pairs,
  method_colors,
  set_colors = setNames(c("#4D4D4D", "#AEAEAE", "#E6E6E6"), c("S1:standard",
    "S2:intersect", "S3:trimmed")),
  heatmap_color_palette = colorRamp2(seq(0, 100, 1), heat.colors(101, rev = TRUE)),
  column_title = "",
  row_names_side = "right",
  legend_name = "No. of\\nmarkers",
  row_names_gp = 10,
  column_title_gp = 12
)
}
\arguments{
\item{method_pairs}{A named list of method comparisons. Each element should be a list
with two components (\emph{data1 (untrimmed)} and \emph{data2 (trimmed)}) containing data frames with:
\itemize{
  \item \emph{cluster}: Cluster identifiers
  \item \emph{gene}: Gene identifiers
}}

\item{method_colors}{Named vector of colors for method annotations. Names should match
the names in \emph{method_pairs}.}

\item{set_colors}{Named vector of colors for set annotations (S1-S3). Default:
\emph{c("S1:standard", "S2:intersect", "S3:trimmed")} with grey colors.}

\item{heatmap_color_palette}{Color mapping function for heatmap. Default:
\emph{colorRamp2(seq(0, 100, 1), heat.colors(101, rev = TRUE))}.}

\item{column_title}{Main title for the heatmap columns.}

\item{row_names_side}{Side for row names ("left" or "right"). Default: "right".}

\item{legend_name}{Title for the heatmap legend. Default: "No. of markers".}

\item{row_names_gp}{Graphics parameters for row names. Default: 10.}

\item{column_title_gp}{Graphics parameters for column title. Default: 12.}
}
\value{
A \emph{Heatmap} object from the ComplexHeatmap package.
}
\description{
Visualizes the impact of scTrimClust's trimming by comparing gene sets between:
1) Default Seurat analysis (no trimming)
2) scTrimClust post-trimming results
}
\details{
scTC_trim_effect creates a heatmap showing the percentage differences in gene sets between method pairs
across clusters.
The heatmap shows three components for each method comparison:
\itemize{
  \item Column 1-3: Unique to method1 (untrimmed), Intersection, Unique to method2 (trimmed)
  \item Rows represent (cell) clusters with counts from first method in parentheses
  \item Columns are split by method pairs
}
}
\examples{
\dontrun{

method_pairs <- list(
  CLR = list(
    data1 = RepeatedHighDim:::scTC_eff_clr,
    data2 = RepeatedHighDim:::scTC_eff_clr_robust
  ),
  LogNorm = list(
    data1 = RepeatedHighDim:::scTC_eff_log,
    data2 = RepeatedHighDim:::scTC_eff_log_robust
  )
)

method_colors <- setNames(grey.colors(2), c("CLR", "LogNorm"))

scTC_trim_effect(
  method_pairs = method_pairs,
  method_colors = method_colors,
  column_title = "nPCs:5, nFeatures:1000"
)

set_colors <- grey.colors(3)
names(set_colors) <- c("S1:standard", "S2:intersect", "S3:trimmed")

scTC_trim_effect(
  method_pairs = method_pairs,
  method_colors = method_colors,
  set_colors = setNames(c("blue", "green", "red"), names(set_colors)),
  heatmap_color_palette = colorRamp2(c(0, 50, 100), c("white", "pink", "purple")),
  column_title = "Custom Color Example"
)
}

}
