% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centers_function_RelativeDistance.R
\name{centers_function_RelativeDistance}
\alias{centers_function_RelativeDistance}
\title{Center of a cluster when the Relative distance is used.}
\usage{
centers_function_RelativeDistance(data, grouping)
}
\arguments{
\item{data}{Matrix. The points that we want to group are in the rows.}

\item{grouping}{List. List with the number of the rows of the data matrix that are in the group \code{[[i]]}.}
}
\value{
A matrix. The row i contains the centers of the group in \code{[[i]]}.
}
\description{
This function calculates the center of a group when the Relative distance is used to group.
}
\examples{
set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
          matrix(runif(20,20,30), nrow = 2, ncol = 10),
          matrix(runif(20,50,70), nrow = 2, ncol = 10))

grouping=list(c(1,2), c(3,4),c(5,6))
centers_function_RelativeDistance(data, grouping)


}
