% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addComposeLookupToCDB.R
\name{addComposeLookupToCDB}
\alias{addComposeLookupToCDB}
\title{Add composition lookups to CDB}
\usage{
addComposeLookupToCDB(
  decompositions,
  CDB,
  maxcol = 10,
  SNOMED = getSNOMED(),
  ...
)
}
\arguments{
\item{decompositions}{vector of filenames of decompose output (read
by fread) or data.frame containing outputs of decompose function}

\item{CDB}{concept database environment, containing a table called
FINDINGS}

\item{maxcol}{maximum number of attributes columns. If NULL it is
determined from the data. It might be helpful to specify it so that
downstream databases and programs know exactly how many columns to
expect. We suggest setting it to 10 which should handle all 
possible SNOMED CT concept decompositions.}

\item{SNOMED}{environment containing a SNOMED CT dictionary}

\item{...}{other arguments to pass to fread}
}
\value{
CDB environment with an additional data.table `COMPOSELOOKUP'
  with columns rootId, attr_1 ... attr_X (up to
  maxcol), with, due_to, without, origId (all with data type
  integer64 and class 'SNOMEDconcept')
}
\description{
Creates a composition lookup table for a set of SNOMED CT concepts
based on output of `decompose', and adds it to the CDB
}
\seealso{
decompose, compose, batchDecompose

Other CDB functions: 
\code{\link{addWordnet}()},
\code{\link{batchDecompose}()},
\code{\link{createCDB}()},
\code{\link{downloadOrphanet}()},
\code{\link{downloadWordnet}()}
}
\concept{CDB functions}
