% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{msgpack_timestamp_encode}
\alias{msgpack_timestamp_encode}
\alias{msgpackTimestampEncode}
\title{'MsgPack' Timestamp}
\usage{
msgpack_timestamp_encode(posix = NULL, seconds = NULL, nanoseconds = NULL)

msgpackTimestampEncode(posix = NULL, seconds = NULL, nanoseconds = NULL)
}
\arguments{
\item{posix}{A POSIXct or POSIXlt or anything that can be coerced to a numeric.}

\item{seconds}{The number of seconds since 1970-01-01 00:00:00 UTC.  Can be negative.  Don't use seconds and nanoseconds if you use posix (and vice versa).}

\item{nanoseconds}{The number of nanoseconds since 1970-01-01 00:00:00 UTC.  Must be less than 1,000,000,000 and greater than 0.}
}
\value{
A serialized timestamp that can be used as input to msgpack_pack.  Briefly, this is an extension type -1 that is variable length, depending on the desired range and precision.
}
\description{
Encodes a timestamp to the 'MsgPack' specifications.
}
\examples{
mt <- Sys.time()
attr(mt, "tzone") <- "UTC"
mp <- msgpack_pack(msgpack_timestamp_encode(mt))
mtu <- msgpack_timestamp_decode(msgpack_unpack(mp))
identical(mt, mtu)
}
