% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{col_auc}
\alias{col_auc}
\title{Column-wise area under ROC curve (AUC)}
\usage{
col_auc(x, y, args = NULL)
}
\arguments{
\item{x}{Matrix or data frame. Rows contain samples and columns contain features/variables.}

\item{y}{Factor of class labels for the data samples. A response vector with one label for each row/component of \code{x}.}

\item{args}{\code{NULL} (default) or list of named arguments: \describe{
\item{direction}{Character vector containing one of the following directions: \code{">"}, \code{"<"} or \code{"auto"} (default),
recycled for each feature so different directions can be used for different features.}
}}
}
\value{
An output is a single matrix with the same number of columns as X and "n choose 2" ( n!/((n-2)! 2!) = n(n-1)/2 ) number of rows,
where n is number of unique labels in y list. For example, if y contains only two unique class labels ( length(unique(lab))==2 )
then output matrix will have a single row containing AUC of each column.
If more than two unique labels are present than AUC is calculated for every possible pairing of classes ("n choose 2" of them).
}
\description{
Calculate area under the ROC curve (AUC) for every column of a matrix or data frame. For better performance, data frame is preferred.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
if (require("MASS", quietly = TRUE) == TRUE) {
  data(cats)
  print(res_cpp <- col_auc(cats[, 2L:3L], cats[, 1L]))
  # Validate with caTools::colAUC()
  if (require("caTools", quietly = TRUE) == TRUE) {
    print(res_r <- caTools::colAUC(cats[, 2L:3L], cats[, 1L]))
    identical(res_cpp, res_r)
  }
}
}
\seealso{
\code{caTools::colAUC} for the original \R implementation.

\code{\link{col_auc_vec}} for the vectorized version.
}
