% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zookin_accessor.R
\name{cumkin}
\alias{cumkin}
\title{Computes the realized kinship}
\usage{
cumkin(kres, T = NULL)
}
\arguments{
\item{kres}{The name of the kres object created by the zoorun function.}

\item{T}{The value chosen to define the base population. When T is not
provided, all classes are considered to estimate the kinship.}
}
\value{
An array with the computed kinship for all the pairs of individuals in
 the analysis.
}
\description{
Computes the realized kinship with respect to a base population by summing the
relatedness from all classes with a rate lower or equal to the threshold T.
This amounts to set the base population approximately 0.5*T generations ago.
Classes with a higher rate are then no longer considered as IBD.
}
