% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMNearestMeanClassifier.R
\name{EMNearestMeanClassifier}
\alias{EMNearestMeanClassifier}
\title{Semi-Supervised Nearest Mean Classifier using Expectation Maximization}
\usage{
EMNearestMeanClassifier(X, y, X_u, method = "EM", scale = FALSE,
  eps = 1e-04)
}
\arguments{
\item{X}{matrix; Design matrix for labeled data}

\item{y}{factor or integer vector; Label vector}

\item{X_u}{matrix; Design matrix for unlabeled data}

\item{method}{character; Currently only "EM"}

\item{scale}{Should the features be normalized? (default: FALSE)}

\item{eps}{Stopping criterion for the maximinimization}
}
\description{
Expectation Maximization applied to the nearest mean classifier assuming Gaussian classes with a spherical covariance matrix.
}
\details{
Starting from the supervised solution, uses the Expectation Maximization algorithm (see Dempster et al. (1977)) to iteratively update the means and shared covariance of the classes (Maximization step) and updates the responsibilities for the unlabeled objects (Expectation step).
}
\references{
Dempster, A., Laird, N. & Rubin, D., 1977. Maximum likelihood from incomplete data via the EM algorithm. Journal of the Royal Statistical Society. Series B, 39(1), pp.1-38.
}
