% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.model.Z.r
\name{pairwise.model.Z}
\alias{pairwise.model.Z}
\title{Pairwise comparisons of model effects}
\usage{
pairwise.model.Z(
  ...,
  nsamp = NULL,
  two.tailed = TRUE,
  predictor = NULL,
  tol = NULL,
  pc.no = NULL,
  gls.null = FALSE
)
}
\arguments{
\item{...}{Either an object of class \code{\link{model.comparison}}, 
or several objects of class \code{\link{lm.rrpp}}.  If the former, arguments of
type = 'Z' and verbose = TRUE are required.  If the latter, a model comparsion analysis
will first be performed with these arguments.}

\item{nsamp}{An optional vector containing the sample sizes for each model fit}

\item{two.tailed}{A logical value to indicate whether a two-tailed test (typical and default) should be performed.}

\item{predictor}{An optional vector to be passed to \code{\link{model.comparison}}, if used.}

\item{tol}{An optional value to be passed to \code{\link{model.comparison}}, if used.}

\item{pc.no}{An optional value to be passed to \code{\link{model.comparison}}, if used.}

\item{gls.null}{An optional logical value to be passed to \code{\link{model.comparison}}, if used.}
}
\value{
A list containing the following
\item{sample.z}{A vector of model effect sizes.}
\item{pairwise.z}{A matrix of pairwise test statistics comparing model effect sizes.}
\item{pairwise.P}{A matrix of pairwise significance levels.}
\item{tails}{Number of tails used for P-value calculation.}
}
\description{
Function generates pairwise statistics for comparing model fits and
returns important statistics for hypothesis tests.
}
\details{
The function statistically compares the effect sizes of two or more models fit
and evaluated using RRPP.  Input for the function is a list of fitted models
of the class 'model.comparison', whose options included type = 'Z' and 
verbose = TRUE when the models were compared with that function.

A two-sample test is performed on each pair of models, comparing the strength 
of model fits to one another (Collyer and Adams 2025). This might be used to 
compare the strength of fit of the data to differing statistical models (as in 
model selection) or for comparing the fit across differing 
datasets for the same model to determine whether the strength of fit in one dataset
is greater than that found in another (see Collyer and Adams 2025). In the latter
case, one is advised to include a vector containing the sample sizes of each
dataset, so that two-sample tests may account for differences in sample size.
}
\examples{
\dontrun{
 data(Pupfish)
 Pupfish$logSize <- log(Pupfish$CS)
 fit1 <- lm.rrpp(coords ~ logSize, data = Pupfish,
 print.progress = FALSE)
 fit2 <- lm.rrpp(coords ~ Pop, data = Pupfish,
 print.progress = FALSE)
 fit3 <- lm.rrpp(coords ~ Sex, data = Pupfish, 
 print.progress = FALSE)
 fit6 <- lm.rrpp(coords ~ logSize + Sex * Pop, data = Pupfish, 
 print.progress = FALSE)
 Mod.C <- model.comparison(fit1, fit2, fit3, fit6,
 pc.no = 4, type = "Z", verbose = TRUE)
 res <- pairwise.model.Z(Mod.C)
 summary(res, stats.table = TRUE)
 summary(res, stats.table = FALSE)
 }
}
\references{
Collyer, M.L., and D.C. Adams. 2025. Permutational Biometry. 
  Volume 1: Univariate Data. Iowa State University Digital Press. (Forthcoming).
}
\author{
Dean Adams and Michael Collyer
}
\keyword{analysis}
