% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMCDM.R
\name{apply.SMCDM}
\alias{apply.SMCDM}
\title{Apply Stratified Multi-Criteria Decision Making (SMCDM) method}
\usage{
apply.SMCDM(
  comparison.mat,
  state.criteria.probs,
  likelihood.vector,
  independent.events = TRUE
)
}
\arguments{
\item{comparison.mat}{the matrix containing alternatives as row names and criteria
as column names and corresponding scores as cell values.}

\item{state.criteria.probs}{the matrix containing the states as column names and
criteria as row names and the corresponding scores as matrix values.}

\item{likelihood.vector}{the vector containing the likelihood of being in each state.}

\item{independent.events}{this parameter is set to TRUE by default which indicates only the
probability of the occurence of each event is required (strati I and II). If set to FALSE
then the user should provide the probabilities of occurrence of all states.}
}
\value{
the SMCDM results
}
\description{
Apply Stratified Multi-Criteria Decision Making (SMCDM) method
}
\examples{
data <- read.csv(system.file("extdata", "SMCDM_input.csv", package = "RMCDA"), header=FALSE)
mat.lst <- read.csv.SMCDM.matrices(data)
comparison.mat <- mat.lst[[1]]
state.criteria.probs <- mat.lst[[2]]
likelihood.vector <- mat.lst[[3]]
apply.SMCDM(comparison.mat, state.criteria.probs, likelihood.vector)
}
