% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COPELAND.R
\name{apply.COPELAND}
\alias{apply.COPELAND}
\title{Apply Copeland Method}
\usage{
apply.COPELAND(mat, beneficial.vector)
}
\arguments{
\item{mat}{A numeric matrix containing the values for different properties
of different alternatives.}

\item{beneficial.vector}{A numeric vector containing the column indices of beneficial
criteria. Non-beneficial criteria are assumed to be the remaining columns.}
}
\value{
A numeric vector containing the calculated Copeland scores for each alternative.
}
\description{
Apply Copeland Method
}
\examples{
mat <- matrix(c(80, 60, 90,
                75, 85, 95,
                70, 65, 85,
                60, 75, 80),
              nrow = 4, byrow = TRUE)
colnames(mat) <- c("Criterion 1", "Criterion 2", "Criterion 3")
beneficial.vector <- c(1, 2, 3)
apply.COPELAND(mat, beneficial.vector)
}
