% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHP.R
\name{apply.AHP}
\alias{apply.AHP}
\title{Apply AHP on the matrices}
\usage{
apply.AHP(A, comparing.competitors)
}
\arguments{
\item{A}{the matrix containing information related to pairwise comparisons of
criteria}

\item{comparing.competitors}{the list of matrices related to pairwise comparisons
of competitors for each criteria}
}
\value{
a list containing
I. The weight of each criteria
II. The criteria alternative unweighted matrix
III. The weighted scores matrix
IV. Competitor final scores
}
\description{
Apply AHP on the matrices
}
\examples{
data <- read.csv(system.file("extdata", "AHP_input_file.csv", package = "RMCDA"), header=FALSE)
mat.lst <- read.csv.AHP.matrices(data)
mat.lst[[1]]->A
mat.lst[[2]]->comparing.competitors
results<- apply.AHP(A, comparing.competitors)
}
