% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{RADnormalization_matrix}
\alias{RADnormalization_matrix}
\title{Normalizes an abundance table to the desired number of ranks}
\usage{
RADnormalization_matrix(
  input,
  max_rank,
  average_over = 1,
  min_rank = 1,
  labels = FALSE,
  count_data = TRUE,
  sample_in_row = TRUE,
  method = "upperlimit",
  verbose = TRUE
)
}
\arguments{
\item{input}{A vector or matrix which contains the abundance values (an abundance table).}

\item{max_rank}{The desired rank to which this method normalizes the input.}

\item{average_over}{Number of times, a normalized RAD is created and averaged to produce the result.}

\item{min_rank}{The minimum rank to which this method normalizes the input.}

\item{labels}{A logical. If \code{TRUE} the label of each rank (ids in the input vector) will be returned.}

\item{count_data}{A logical. \code{TRUE} means that the input vector contains counts (integer values) otherwise contains the relative abundances. In the current version only counts are accepted.}

\item{sample_in_row}{A logical. \code{TRUE} means that the abundance vector of samples are represented in rows otherwise in columns.}

\item{method}{Sets the stop criterion for normalization. This should be one of
"lowerlimit", "middle" or
"upperlimit". Method affects the final result.
lowerlimit: Samples from species pool one by one, until reaches max_rank.
middle: Samples from species pool with random size until the sampled vector has desired ranks (max_rank).
upperlimit: Removes from species pool one by one, until reaches max_rank.}

\item{verbose}{A logical. If \code{TRUE}, prints the progress in percent in console.}
}
\value{
A list of following items:

$norm_matrix A matrix which contains normalized RADs sum up to 1. If \code{labels = TRUE}, it would also contain the labels.

$inputs A list which contains inputs used for creating normalized RADs. It does not contain \code{input} because it could be very big.
}
\description{
Normalizes an abundance table to the desired number of ranks
}
\examples{
data("gut_otu_table")
rads <- gut_otu_table
#plot original rads
line_cols <- c("green","red","blue")
sample_classes <- c(1,1,1,1,2,2,3,3,1,1,2,3,3,1,1,2,3,3)
plot(1,xlim = c(1,2000),ylim = c(1,20000),col = "white",log  = "xy",
     xlab = "Rank",ylab = "Abundance",main = "Original RADs from antibiotic data set")
for(i in 1:nrow(rads)){
    temp <- sort(rads[i,],decreasing = TRUE)
    temp <- temp[temp>0]
    lines(x = temp,lwd = 2,col = line_cols[sample_classes[i]])
}
legend("bottomleft",bty = "n",legend = c("pre Cp","under Cp","post Cp"),col = line_cols,lwd = 3)


nrads <- RADnormalization_matrix(input = rads,max_rank = 400,average_over = 20,sample_in_row = TRUE)
nrads <- nrads$norm_matrix

plot(1,xlim = c(1,400),ylim = c(4e-5,1),col = "white",log  = "xy",
     xlab = "Rank",ylab = "Abundance",
     main = "NRADs from antibiotic data set with R = 400 \n with average_over = 20")
for(i in 1:nrow(nrads)){
    lines(x = nrads[i,],lwd = 2,col = line_cols[sample_classes[i]])
}
legend("bottomleft",bty = "n",legend = c("pre Cp","under Cp","post Cp"),col = line_cols,lwd = 3)
}
\seealso{
\code{\link{RADnormalization}} for normalize an abundance vector. This function return more details compared to \code{\link{RADnormalization_matrix}},
         \code{\link{representative_point}} for study the representative of groups of samples in a multi-dimensional scaling plot,
         \code{\link{representative_RAD}} for study the representative of group of norm rads.
}
