% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PartitionDistance.R
\name{SplitStatus}
\alias{SplitStatus}
\alias{BipartitionStatus}
\alias{SharedSplitStatus}
\alias{SharedBipartitionStatus}
\title{Matching partitions}
\usage{
SplitStatus(trees, cf = trees[[1]])

SharedSplitStatus(trees, cf)
}
\arguments{
\item{trees}{A list of trees of class \code{\link[ape:read.tree]{phylo}},
with identically labelled tips.}

\item{cf}{Comparison tree of class \code{\link[ape:read.tree]{phylo}}.  If unspecified,
each tree is compared to the first tree in \code{trees}.}
}
\value{
Returns a two dimensional array.
Rows correspond to the input trees, and are named if names were present.
Columns report:

\strong{N}: The total number of partitions present in the two trees,
i.e. \emph{P1} + \emph{P2}.

\strong{P1}: The number of partitions present in tree 1.

\strong{P2}: The number of partitions present in tree 2.

\strong{s}: The number of partitions present in both trees.

\strong{d1}: The number of partitions present in tree 1,
but contradicted by tree 2.

\strong{d2}: The number of partitions present in tree 2,
but contradicted by tree 1.

\strong{r1}: The number of partitions present in tree 1, and neither
present nor contradicted in tree 2.

\strong{r2}: The number of partitions present in tree 2, and neither
present nor contradicted in tree 1.
}
\description{
Calculates how many of the partitions present in tree 1 are also present in
tree 2 (\code{s}),
how many of the partitions in tree 1 are absent in tree 2 (\code{d1}),
and how many of the partitions in tree 2 are absent in tree 1 (\code{d2}).
The Robinson-Foulds (symmetric partition) distance is the sum of the
latter two quantities, i.e. \code{d1} + \code{d2}.
}
\section{Functions}{
\itemize{
\item \code{SharedSplitStatus()}: Reports split statistics obtained after removing all
tips that do not occur in both trees being compared.

}}
\examples{
data("sq_trees")

# Calculate the status of each quartet
splitStatuses <- SplitStatus(sq_trees)

# Calculate the raw symmetric difference (i.e. Robinson–Foulds distance)
RawSymmetricDifference(splitStatuses)

# Normalize the Robinson Foulds distance by dividing by the number of 
# splits present in the two trees:
RawSymmetricDifference(splitStatuses) / splitStatuses[, "N"]

# Normalize the Robinson Foulds distance by dividing by the total number of 
# splits that it is possible to resolve for `n` tips:
nTip <- length(sq_trees[[1]]$tip.label)
nPartitions <- 2 * (nTip - 3L) # Does not include the nTip partitions that 
                               # comprise but a single tip
RawSymmetricDifference(splitStatuses) / nPartitions


}
\references{
\itemize{
\item \insertRef{Robinson1981}{Quartet}
\item \insertRef{Penny1985}{Quartet}
}
}
\seealso{
Other element-by-element comparisons: 
\code{\link{CompareQuartets}()},
\code{\link{CompareQuartetsMulti}()},
\code{\link{CompareSplits}()},
\code{\link{PairSharedQuartetStatus}()},
\code{\link{QuartetState}()},
\code{\link{SharedQuartetStatus}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{element-by-element comparisons}
