% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetDistance.R, R/tqDist.r
\name{SharedQuartetStatus}
\alias{SharedQuartetStatus}
\alias{QuartetStatus}
\alias{ManyToManyQuartetAgreement}
\alias{TwoListQuartetAgreement}
\alias{SingleTreeQuartetAgreement}
\title{Status of quartets}
\usage{
SharedQuartetStatus(trees, cf = trees[[1]])

QuartetStatus(trees, cf = trees[[1]], nTip = NULL)

ManyToManyQuartetAgreement(trees, nTip = NULL)

TwoListQuartetAgreement(trees1, trees2)

SingleTreeQuartetAgreement(trees, comparison)
}
\arguments{
\item{trees}{A list of trees of class \code{\link[ape:read.tree]{phylo}},
with identically labelled tips.}

\item{cf}{Comparison tree of class \code{\link[ape:read.tree]{phylo}}.  If unspecified,
each tree is compared to the first tree in \code{trees}.}

\item{nTip}{Integer specifying number of tips that could have occurred
in \code{trees}.  Useful if comparing trees from different data sources that
contain non-overlapping tips.
If \code{NULL}, the default, then trees are assumed to contain the same tips.
If \code{TRUE}, then a vector is generated automatically by counting all unique
tip labels found in \code{trees} or \code{cf}.}

\item{trees1, trees2}{List or \code{multiPhylo} objects containing
trees of class \code{phylo}.}

\item{comparison}{A tree of class \code{\link[ape:read.tree]{phylo}} against
which to compare \code{trees}.}
}
\value{
\code{QuartetStatus()} returns a two dimensional array. Rows correspond to the input trees; the first row will report a perfect match if the first tree is specified as the comparison tree (or if \code{cf} is not specified).  Columns list the status of each quartet:
\describe{
\item{N}{The total number of quartet \emph{statements} for two trees of \emph{n} leaves,
i.e. 2 \emph{Q}.}
\item{Q}{The total number of quartets for \emph{n} leaves.}
\item{s}{The number of quartets that are resolved identically in both trees.}
\item{d}{The number of quartets that are resolved differently in each tree.}
\item{r1}{The number of quartets that are resolved in tree 1, but not in tree 2.}
\item{r2}{The number of quartets that are resolved in tree 2, but not in tree 1.}
\item{u}{The number of quartets that are unresolved in both trees.}
}

\code{ManyToManyQuartetAgreement()} returns a three-dimensional array
listing, for each pair of trees in turn, the number of quartets in each
category.

\code{TwoListQuartetAgreement()} returns a three-dimensional array listing,
for each pair of trees in turn, the number of quartets in each category.

\code{SingleTreeQuartetAgreement()} returns a two-dimensional array listing,
for tree in \code{trees}, the total number of quartets and the
number of quartets in each category.
The \code{comparison} tree is treated as \code{tree2}.
}
\description{
Determines the number of quartets that are consistent within pairs of trees.
}
\details{
Given a list of trees, returns the number of quartet statements
\insertCite{Estabrook1985}{Quartet} present in the
reference tree (the first entry in \code{trees}, if \code{cf} is not specified)
that are also present in each other tree.  A random pair of fully resolved
trees is expected to share \code{choose(n_tip, 4) / 3} quartets.

If trees do not bear the same number of tips, \code{SharedQuartetStatus()} will
consider only the quartets that include taxa common to both trees.

From this information it is possible to calculate how many of all possible
quartets occur in one tree or the other, though there is not yet a function
calculating this; \href{https://github.com/ms609/Quartet/issues/new}{let us know}
if you would appreciate this functionality.

The status of each quartet is calculated using the algorithms of
\insertCite{Brodal2013;textual}{Quartet} and
\insertCite{Holt2014;textual}{Quartet}, implemented in the
tqdist C library \insertCite{Sand2014}{Quartet}.
}
\section{Functions}{
\itemize{
\item \code{SharedQuartetStatus()}: Reports split statistics obtained after removing all
tips that do not occur in both trees being compared.

\item \code{ManyToManyQuartetAgreement()}: Agreement of each quartet, comparing each pair of
trees in a list.

\item \code{TwoListQuartetAgreement()}: Agreement of each quartet in trees in one list with
each quartet in trees in a second list.

\item \code{SingleTreeQuartetAgreement()}: Agreement of each quartet in trees in a list with
the quartets in a comparison tree.

}}
\examples{
data("sq_trees")
# Calculate the status of each quartet relative to the first entry in 
# sq_trees
sq_status <- QuartetStatus(sq_trees)

# Calculate the status of each quartet relative to a given tree
two_moved <- sq_trees[5:7]
sq_status <- QuartetStatus(two_moved, sq_trees$ref_tree)

# Calculate Estabrook et al's similarity measures:
SimilarityMetrics(sq_status)

# Compare trees that include a subset of the taxa 1..10
library("TreeTools", quietly = TRUE, warn.conflict = FALSE)
QuartetStatus(BalancedTree(1:5), BalancedTree(3:8), nTip = 10)

# If all taxa studied occur in `trees` or `cf`, set `nTip = TRUE`
QuartetStatus(BalancedTree(1:5), BalancedTree(3:10), nTip = TRUE)
 
# Calculate Quartet Divergence between each tree and each other tree in a 
# list
QuartetDivergence(ManyToManyQuartetAgreement(two_moved))
# Calculate Quartet Divergence between each tree in one list and each 
# tree in another
QuartetDivergence(TwoListQuartetAgreement(sq_trees[1:3], sq_trees[10:13]))
}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item Use splits (groups/clades defined by nodes or edges of the tree) instead
of quartets as the unit of comparison: \code{\link[=SplitStatus]{SplitStatus()}}.
\item Generate distance metrics from quartet statuses: \code{\link[=SimilarityMetrics]{SimilarityMetrics()}}.
}

Other element-by-element comparisons: 
\code{\link{CompareQuartets}()},
\code{\link{CompareQuartetsMulti}()},
\code{\link{CompareSplits}()},
\code{\link{PairSharedQuartetStatus}()},
\code{\link{QuartetState}()},
\code{\link{SplitStatus}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{element-by-element comparisons}
