% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCr_Pval.r
\name{BCr_Pval}
\alias{BCr_Pval}
\title{P value testing for normality of (transformed) data}
\usage{
BCr_Pval(correl, n, censor=0, winsor=0, isBC=FALSE, is2pBC=FALSE)
}
\arguments{
\item{correl}{the QQ correlation coefficient}

\item{n}{the sample size}

\item{censor}{\emph{optional} (default of 0) - the number of readings censored
on the left}

\item{winsor}{\emph{optional} (default of 0) - the number of readings winsorized
in each tail}

\item{isBC}{\emph{optional} (default of FALSE) - if TRUE,
the QQCC is after Box-Cox transformation}

\item{is2pBC}{\emph{optional} (default of FALSE) - if TRUE,
the QQCC is after a shifted Box-Cox transformation.}
}
\value{
\item{Pval}{the P value}
}
\description{
Computes the P value of the quantile-quantile correlation coefficient (QQCC).
}
\details{
Lower-level function, called by other functions in package.
It takes information from a quantile-quantile regression, along with the
circumstances leading up to it, to produce a P value testing for normality.
}
\examples{
# compute the Pvalue for two QQCC's
BCr_Pval(c(0.993, 0.99), 120)
# if censored
BCr_Pval(c(0.993, 0.99), 120, censor=3)
# if winsorized
BCr_Pval(c(0.993, 0.99), 120, winsor=3)
# on Box-Cox transformed data
BCr_Pval(c(0.993, 0.99), 120, isBC=TRUE)
# on Box-Cox transformed data, and winsorized
BCr_Pval(c(0.993, 0.99), 120, isBC=TRUE, winsor=3)

}
\references{
Hawkins DM, Esquivel RN (2024). A Quantile-Quantile Toolbox for
Reference Intervals.  \emph{The Journal of Applied Laboratory Medicine}, \strong{9:2}, 357-370.
}
\author{
Douglas M. Hawkins, Jessica J. Kraker \href{mailto:krakerjj@uwec.edu}{krakerjj@uwec.edu}
}
